**free
// RPG BATTLE DEV 2025 - Manche 2 - Epreuve 1 - Du 15 au 17 octobre 2025

// Objectif : afficher le top 3 des coureurs cyclistes du Tour de France avec l'écart en minutes et secondes

// Contexte :
//  - La table TEAMLIB/ETAPES contient la liste des temps des coureurs pour chaque étape du tour
//    3 colonnes : le numéro de l'étape (NUM_ETP), le numéro du dossard (DOSSARD) et la durée de l'étape réalisée par le coureur (DUREE)
//  - Si la colonne DUREE contient la valeur nulle c'est que le coureur a abandonné l'étape

// Résultat à afficher sous cette forme, par SND-MSG :
// OR : dossard numéro 2
// ARGENT : dossard numéro 4 : + 8 mn 55 secondes
// BRONZE : dossard numéro 6 : + 35 mn 31 secondes

// Consignes :
//  1. Ne pas modifier les lignes de code déjà présentes), ajouter vos lignes de code nécessaires
//  2. Utiliser uniquement des instructions RPG natives (pas de SQL, pas d'appels d'API...)

// Critères d'évaluation :
//  1. Le résultat doit être celui demandé
//  2. Le code présent ne doit pas être modifié
//  3. Le code doit être le plus simple, le plus lisible possible et le plus optimisé
//  4. Le programme doit s'appeler E3 dans votre bibliothèque TEAMXX

// -----------------------------------------------------------------------------
// Votre profil IBM i : TEAMXX
// -----------------------------------------------------------------------------

ctl-opt alwnull(*usrctl) actgrp(*new);

dcl-f etapes rename(etapes:fetapes);

dcl-ds tResultat dim(*auto:200) qualified inz;
  numDossard like(dossard);  // Numéro du dossard
  cumulTemps uns(5);         // Temps cumulé de toutes les étapes
  abandon    ind;            // Abandon = *ON si un coureur a abondonné une étape
end-ds;

dcl-s vHeure time; // Initialisée à t'00.00.00'

// Lecture de toutes les étapes et ajout des temps cumulés dans le tableau tResultat
read etapes;
dow not %eof;
  ajoutEtape();
  read etapes;
enddo;

// Affichage du podium
affichagePodium();

*inlr = *on;

// ---------------------------------------------------------------------------------------------
//  Ajout des temps cumulés dans le tableau tResultat
dcl-proc ajoutEtape;

  dcl-s indice uns(5);

  indice = %lookup(dossard:tResultat(*).numDossard);

  if indice = 0; // Si le numéro de dossard n'existe pas
    indice = %elem(tResultat) + 1;
    tResultat(indice).numDossard = dossard;
  endif;

  if %nullind(duree); // Si le coureur a abandonné
    tResultat(indice).abandon = *on;
  else;
    tResultat(indice).cumulTemps += %diff(duree:vHeure:*s);
  endif;

end-proc;


// Affichage du résultat du podium (les 3 premiers)
dcl-proc affichagePodium;

  dcl-s medaille varchar(10);
  dcl-s message  varchar(100);
  dcl-s cpt      uns(5);

  sorta(a) tResultat %fields(abandon:cumulTemps);

  for-each medaille in %list('OR':'ARGENT':'BRONZE');
    cpt +=1;
    message = %concat(' : ' : medaille : 'dossard numéro ' + %char(tResultat(cpt).numDossard));
    if cpt > 1;
      message = %concat(' : ' : message : '+ ' + affichageEcart(tResultat(cpt).cumulTemps - tResultat(1).cumulTemps));
    endif;
    snd-msg message;
  endfor;

end-proc;


// Affichage du temps d'écart entre les coureurs en minutes et secondes
dcl-proc affichageEcart;

  dcl-pi *n varchar(50);
    t1 uns(5) const;
  end-pi;

  reset vHeure;
  vHeure += %seconds(t1);
  return %concat(*none : %char(%subdt(vHeure:*mn)) : ' mn ' : %char(%subdt(vHeure:*s)) : ' secondes');
  // OU return %trim(%editw(%dec(vHeure) : '    &mn&  &secondes'));
end-proc;
