**free
// RPG BATTLE DEV 2025 - Manche 1 - Epreuve 2 - Du 8 au 10 octobre 2025

// Objectif : afficher la liste des vols possibles depuis un aéroport de départ

// Contexte :
//  - La table TEAMLIB/VOLS contient la liste des vols (2 colonnes : aéroport de départ (DEPART), aéroport d'arrivée (ARRIVEE))
//  - Vous disposez également de l'index TEAMLIB/VOLSBYDEP (clé sur la colonne DEPART en ascendant)

// Résultat attendu (exemple pour un départ de la ville de New-York ) :
//
// Vols au départ de New-York
// New York > Paris
// New York > Paris > Madrid
// New York > Paris > Caire
// New York > Paris > Rome
// New York > Londres
// New York > Londres > Athenes
// New York > Londres > Athenes > Nicosie
// New York > Los Angeles
// New York > Los Angeles > Tokyo
// New York > Los Angeles > Tokyo > Hawaii


// Consignes :
//  1. Ne pas modifier les lignes de code déjà présentes), ajouter vos lignes de code nécessaires
//  2. Utiliser uniquement des instructions RPG natives (pas de SQL, pas d'appels d'API...)
//  3. Les vols pour lesquels un cycle serait détecté ne doivent pas être affichés

// Critères d'évaluation :
//  1. Le résultat doit être celui demandé
//  2. Le code présent ne doit pas être modifié
//  3. Le code doit être le plus simple, le plus lisible possible et le plus optimisé
//  4. Le programme doit s'appeler E2 dans votre bibliothèque TEAMXX

// -----------------------------------------------------------------------------
// Votre profil IBM i : TEAMXX
// -----------------------------------------------------------------------------
ctl-opt actgrp(*new);

dcl-f volsbydep rename(vols:fvols) keyed data(*nocvt);

dcl-s origine like(depart);

// Exemple 1
origine = 'New York';
snd-msg ('Vols au départ de : ' + origine);
affichageVol(origine:origine);

// Exemple 2
origine = 'Francfort';
snd-msg ('Vols au départ de : ' + origine);
affichageVol(origine:origine);

// Exemple 3
origine = 'Paris';
snd-msg ('Vols au départ de : ' + origine);
affichageVol(origine:origine);

*inlr = *on;


// Procédure d'affichage des vols à partir de la ville d'origine
// La procédure est appelée de façon récursive

// On teste si on boucle (cycle),
//  c'est à dire le cas suivant : ville_depart1 --> ville_arrivée1 --> ville_départ1

dcl-proc affichageVol;

  dcl-pi *n;
    ville   like(depart);
    chemin  varchar(200) const;
  end-pi;

  dcl-ds dsVol likerec(fvols);
  dcl-ds tVols likeds(dsVol) dim(*auto:100);
  dcl-s  nouveauChemin like(chemin);
  dcl-s  indice int(5);

  // Remplissage des différentes destinations à partir d'une ville d'origine
  setll ville volsbydep;
  if %equal;
    reade ville volsbydep dsVol;
    dow not %eof;
      tVols(*next) = dsVol;
      reade ville volsbydep dsVol;
    enddo;
  endif;

  // Affichage des différents chemins
  for indice=1 to %elem(tVols);
    if %scan(tVols(indice).arrivee : chemin) = 0; // Pour éviter de boucler
      nouveauChemin = %concat(' > ' : chemin : tVols(indice).arrivee);
      snd-msg nouveauChemin;
      affichageVol(tVols(indice).arrivee:nouveauChemin);  // Appel récursif
    endif;
  endfor;

end-proc;
