**free
// RPG BATTLE DEV 2025 - Manche 1 - Epreuve 1 - Du 8 au 10 octobre 2025

// Objectif : répondre aux 9 questions ci-dessous

// Consignes :
//  1. Ne pas modifier les lignes de code déjà présentes (sauf pour la question 5), ajouter vos lignes de code nécessaires
//  2. Utiliser uniquement des instructions RPG natives (pas de SQL, pas d'appels d'API...)

// Critères d'évaluation :
//  1. Le résultat doit être celui demandé
//  2. Le code présent ne doit pas être modifié
//  3. Le code doit être le plus simple, le plus lisible possible et le plus optimisé
//  4. Le programme doit s'appeler E1 dans votre bibliothèque TEAMXX

// -----------------------------------------------------------------------------
// Votre profil IBM i : TEAMXX
// -----------------------------------------------------------------------------

ctl-opt decedit('0,') dclopt(*nochgdslen) expropts(*usedecedit:*alwblanknum)
        bnddir('TEAMLIB/BATTLE2025');

dcl-ds ds1;
  z1 char(10);
end-ds;

dcl-s langages varchar(10) dim(*auto:20);
dcl-s ts1 timestamp inz(z'2025-10-08-14.20.30.666');
dcl-s ts2 timestamp inz(z'2025-10-08-14.20.32.000');

dcl-s z2  char(%size(ds1)); // A ne pas décommenter avant la question 5

dcl-s z3  varchar(100) inz('"RPG Battle Dev 2025" - Organisé par COMMON France et IBM');
dcl-s z3w like(z3);

dcl-s z4  varchar(8);
dcl-s z5  varchar(20) ccsid(*utf8) inz('áëiou');

dcl-pr entiersToRomains varchar(30) dim(5);
  tEntiers int(5) dim(5) value;
end-pr;

dcl-s z6 varchar(30) dim(5);
dcl-s romain varchar(30);

langages = %list('CL':'RPG':'COBOL':'C':'C++':'Java':'Python');

// 1. Afficher, par SND-MSG, la date (du travail) du jour au format AAAA/MM/JJ
snd-msg %char(%date():*longjobrun); // *longjobrun = année sur 4 - Job : DATFMT = *YMD et DATSEP = '/'

// 2. Afficher, par SND-MSG, l'horodate (système) du jour sous la forme AAAA-MM-JJ-HH.MN.SS
snd-msg %char(%timestamp(*sys:0)); // 0 : nombre de fractions de secondes : on s'arrête aux secondes

// 3. Afficher, par SND-MSG, les valeurs du tableau LANGAGES sous la forme CL;RPG;COBOL;C;C++;Java;Python
snd-msg %concatarr(';':langages);

// 4. Afficher, par SND-MSG, la différence exacte en secondes entre TS2 et TS1 : 1,334
snd-msg %char(%diff(ts2:ts1:*s:3)); // 3 : nombre de fractions de secondes : millisecondes

// 5. Décommenter la déclaration de la zone Z2, puis afficher, par SND-MSG, la taille occupée en mémoire de la zone Z2 : 10
//    Si vous ne trouvez pas comment faire, merci de mettre à nouveau en commentaires la déclaration afin que votre source puisse se compiler avec les questions suivantes
snd-msg %char(%size(z2)); // dclopt(*nochgdslen) permet d'indiquer que la taille de la DS sera fixe

// 6. Afficher, par SND-MSG, le dernier mot du texte entre guillemets de la zone Z3 : 2025
//z3w = %subst(z3 : 1 : %scanr('"' : z3)-1);
z3w = %left(z3 : %scanr('"' : z3)-1);
snd-msg %subst(z3w : %scanr(' ' : z3w)+1);

// 7. Afficher, par SND-MSG, le résultat de la conversion en décimal de la zone Z4, dans les 2 cas suivants :
z4 = '1.584,73';
// Le SND-MSG doit renvoyer 1584,73
snd-msg %char(%dec(z4:8:2)); // expropts(*usedecedit)

z4 = *blanks;
// Le SND-MSG doit renvoyer 0,00
snd-msg %char(%dec(z4:5:2)); // expropts(*alwblanknum)

// 8. Afficher, par SND-MSG, la longueur du contenu de la zone Z5 : 5
//    puis afficher, par SND-MSG, les 3 premiers caractères de la zone Z5 : áëi
snd-msg %char(%charcount(z5)); // Les caractères des variables Unicode UTF8 sont codés sur 1 ou 2 octets
snd-msg %left(z5:3:*natural);


// 9. Dans le programme de service TEAMLIB/BATTLE2025 vous disposez d'une procédure entiersToRomains qui prend une liste d'entiers en paramètre
//    et qui renvoie la liste de ces entiers convertis en chiffres romains
//    Voici le prototype de cette procédure :
//     dcl-pr entiersToRomains varchar(30) dim(5);
//       tEntiers int(5) dim(5) value;
//     end-pr;
//    Ce programme de service est référencé dans le répertoire de liage TEAMLIB/BATTLE2025
//
//    En utilisant cette procédure entiersToRomains, afficher par SND-MSG le résultat de la conversion des 5 entiers suivants : 18, 400, 944, 1237 et 3064
//    Le résultat attendu est le suivant :
//      XVIII
//      CD
//      CMXLIV
//      MCCXXXVII
//      MMMLXIV

z6 = entiersToRomains(%list(18:400:944:1237:3064)); // bnddir('TEAMLIB/BATTLE2025') pour la référence à entiersToRomains
for-each romain in z6;
  snd-msg romain;
endfor;

*inlr = *on;
